/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Modifier;

import com.c2h6s.etshtinker.util.slotUtil;
import com.hoshino.cti.Modifier.Base.PressurizableModifier;
import com.hoshino.cti.Modifier.capability.PressurizableToolCap;
import com.hoshino.cti.util.CommonUtil;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.behavior.ToolDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.DurabilityDisplayModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileLaunchModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class PressureLoaded
extends PressurizableModifier
implements ToolDamageModifierHook,
BreakSpeedModifierHook,
MeleeDamageModifierHook,
ProjectileLaunchModifierHook,
AttributesModifierHook,
DurabilityDisplayModifierHook {
    @Override
    protected void registerHooks(ModuleHookMap.Builder builder) {
        super.registerHooks(builder);
        builder.addHook((Object)this, new ModuleHook[]{ModifierHooks.TOOL_DAMAGE, ModifierHooks.BREAK_SPEED, ModifierHooks.MELEE_DAMAGE, ModifierHooks.PROJECTILE_LAUNCH, ModifierHooks.ATTRIBUTES, ModifierHooks.DURABILITY_DISPLAY});
    }

    @Override
    public int getBaseVolume(ModifierEntry entry) {
        return 5000 * entry.getLevel();
    }

    @Override
    public float getMaxPressure(ModifierEntry entry) {
        return Math.min(20, 5 * entry.getLevel());
    }

    public int onDamageTool(IToolStackView tool, ModifierEntry modifier, int amount, @Nullable LivingEntity livingEntity) {
        if (100 * amount < PressurizableToolCap.getAir(tool)) {
            PressurizableToolCap.addAir(tool, -100 * amount);
            return 0;
        }
        if (PressurizableToolCap.getAir(tool) > 100) {
            int minus = PressurizableToolCap.getAir(tool) / 100;
            PressurizableToolCap.addAir(tool, -100 * minus);
            return amount - minus;
        }
        return amount;
    }

    public void onBreakSpeed(IToolStackView tool, ModifierEntry modifier, PlayerEvent.BreakSpeed event, Direction direction, boolean isEffective, float miningSpeedModifier) {
        Optional pos = event.getPosition();
        if (!isEffective || pos.isEmpty()) {
            return;
        }
        event.setNewSpeed(event.getNewSpeed() * (1.0f + (float)tool.getPersistentData().getInt(PressurizableToolCap.AIR_KEY) * (float)modifier.getLevel() / 2.0f));
    }

    public float getBonus(IToolStackView tool, ModifierEntry modifier) {
        return PressurizableToolCap.getPressure(tool) > 0.0f ? (PressurizableToolCap.getPressure(tool) + (float)modifier.getLevel()) / 40.0f : 0.0f;
    }

    public float getMeleeDamage(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float baseDamage, float damage) {
        float multiplier = 1.0f + this.getBonus(tool, modifier);
        if (PressurizableToolCap.getAir(tool) > 100) {
            PressurizableToolCap.addAir(tool, -((int)(100.0f * multiplier)));
            return damage * multiplier;
        }
        return damage;
    }

    @Override
    public void addTooltip(IToolStackView tool, ModifierEntry modifierEntry, @Nullable Player player, List<Component> list, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        super.addTooltip(tool, modifierEntry, player, list, tooltipKey, tooltipFlag);
        list.add((Component)Component.m_237115_((String)"cti.tooltip.modifier.pressure_damage").m_130946_(" +").m_130946_(String.format("%.1f", Float.valueOf(this.getBonus(tool, modifierEntry) * 100.0f))).m_130946_("%").m_130940_(ChatFormatting.GREEN));
    }

    public void onProjectileLaunch(IToolStackView tool, ModifierEntry modifier, LivingEntity livingEntity, Projectile projectile, @Nullable AbstractArrow abstractArrow, NamespacedNBT namespacedNBT, boolean b) {
        float multiplier = 1.0f + this.getBonus(tool, modifier);
        if (PressurizableToolCap.getAir(tool) > 100 && projectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            PressurizableToolCap.addAir(tool, -((int)(100.0f * multiplier)));
            arrow.m_36781_(arrow.m_36789_() * (double)multiplier);
        }
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot equipmentSlot, BiConsumer<Attribute, AttributeModifier> biConsumer) {
        if (slotUtil.ARMOR.contains(equipmentSlot) && this.getBonus(tool, modifier) > 0.0f) {
            biConsumer.accept(Attributes.f_22284_, new AttributeModifier(CommonUtil.UUIDFromSlot(equipmentSlot, modifier.getId()), Attributes.f_22284_.m_22087_(), (double)this.getBonus(tool, modifier), AttributeModifier.Operation.MULTIPLY_BASE));
            biConsumer.accept(Attributes.f_22285_, new AttributeModifier(CommonUtil.UUIDFromSlot(equipmentSlot, modifier.getId()), Attributes.f_22285_.m_22087_(), (double)this.getBonus(tool, modifier), AttributeModifier.Operation.MULTIPLY_BASE));
            biConsumer.accept(Attributes.f_22278_, new AttributeModifier(CommonUtil.UUIDFromSlot(equipmentSlot, modifier.getId()), Attributes.f_22278_.m_22087_(), (double)this.getBonus(tool, modifier), AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    @Nullable
    public Boolean showDurabilityBar(IToolStackView tool, ModifierEntry modifierEntry) {
        return PressurizableToolCap.getAir(tool) > 0;
    }

    public int getDurabilityWidth(IToolStackView tool, ModifierEntry modifierEntry) {
        return (int)((float)(PressurizableToolCap.getAir(tool) * 12) / (PressurizableToolCap.getMaxPressure(tool) * (float)PressurizableToolCap.getBaseVolume(tool))) + 1;
    }

    public int getDurabilityRGB(IToolStackView iToolStackView, ModifierEntry modifierEntry) {
        return 0xFFFFFF;
    }
}

